//
//  MSWViewController.m
//  Midi to Switch for iOS
//
//  Created by Tim Gerber on 13.01.13.
//  Copyright (c) 2013 Tim Gerber. All rights reserved.
//

#import "MSWViewController.h"
#import "midiStrings.h"

@interface MSWViewController ()

@end

@implementation MSWViewController

@synthesize invertSwitch, toggleSwitch, pulseSwitch, directSwitch, swpSwitch, idStepper;
@synthesize idLabel, channelStepper, channelLabel, befehlStepper, befehlLabel;
@synthesize wertLabel, wertStepper, sendButton, midi, zeitLabel, zeitSlider;

//                 Start Herst-ID          FSM-ID            Msg/CH VV   mode  Zeit  Ende
UInt8 Befehl[] = { 0xF0, 0x00, 0x20, 0x0D, 0x7F, 0x05, 0x02, 0x10, 0x48, 0x08, 0x14, 0xF7 };
//                  0     1      2   3      4    5      6    7     8     9      10   11
const UInt8 Werk[] = { 0xF0, 0x00, 0x20, 0x0D, 0x7F, 0x05, 0x02, 0x10, 0x48, 0x08, 0x14, 0xF7 };

UInt8 testNote[] = { 0x90, 0x48, 127   };

NSArray *notenliste = nil;
NSArray *zahlenListe = nil;
NSArray *ctrlListe = nil;

NSArray *befehle = nil;
NSArray *ChannelWahl = nil; ;
NSArray *IDWahl = nil;

bool noteIsOn = false;

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    befehle = [NSArray arrayWithObjects:@"Note", @"Controller", @"Prgr. Change", @"Start/Stop", @"SysEx", nil];
    ChannelWahl = [NSArray arrayWithObjects:@"Channel 1", @"Channel 2", @"Channel 3", @"Channel 4", @"Channel 5", @"Channel 6", @"Channel 7", @"Channel 8", @"Channel 9", @"Channel 10", @"Channel 11", @"Channel 12", @"Channel 13", @"Channel 14", @"Channel 15", @"Channel 16", nil];
    IDWahl = [NSArray arrayWithObjects:@"Standard-ID", @"Device-ID 1", @"Device-ID 2", @"Device-ID 3", @"Device-ID 4", @"Device-ID 5", @"Device-ID 6", @"Device-ID 7", @"Device-ID 8", @"Device-ID 9", @"Device-ID 10", @"Device-ID 11", @"Device-ID 12", @"Device-ID 13", @"Device-ID 14", @"Device-ID 15", @"Device-ID 16", nil];

    if (self) {
        midi = [[PGMidi alloc] init];
        midiStrings *myMidiListen = [[midiStrings alloc] init];
        notenliste = myMidiListen.NotenListe;
        zahlenListe = myMidiListen.zahlenListe;
        ctrlListe = myMidiListen.ctrlListe;        
    }    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)send:(id)sender {
    if ((sender == sendButton) || (directSwitch.on)) [midi sendBytes:Befehl size:sizeof(Befehl)];
    //[midi sendBytes:Werk size:sizeof(Werk)];

}

- (IBAction)test:(id)sender {
    if (noteIsOn) {
        testNote[0] = 0x80;
    } else testNote[0] = 0x90;
    [midi sendBytes:testNote size:sizeof(testNote)];
}

- (IBAction)inverse:(id)sender {
    int mode = 0;
    if (invertSwitch.on) mode = mode + 1;
    if (toggleSwitch.on) mode = mode + 2;
    if (pulseSwitch.on) mode = mode + 4;
    if (swpSwitch.on) mode = mode + 8;
    Befehl[9] = mode;
    [self send:sender];
}

- (IBAction)toggle:(id)sender {
    if (pulseSwitch.on) [pulseSwitch setOn:false];
    [self inverse:sender];
}

- (IBAction)pulse:(id)sender {
    if (toggleSwitch.on) [toggleSwitch setOn:false];
    [self inverse:sender];

}

- (IBAction)swp:(id)sender {
    [self inverse:sender];
}

- (IBAction)idChange:(id)sender {
    [idLabel setText:[IDWahl objectAtIndex:idStepper.value]];
    if (idStepper.value == 0 ) Befehl[4] = 0x7F;
    else Befehl[4] = idStepper.value -1;
    
    //if (Befehl[8] == 0x48) Befehl[8] = 0x36;
    //else Befehl[8] = 0x48;
    [self send:sender];
}

- (IBAction)channelChange:(id)sender {
    int channel = channelStepper.value;
    [channelLabel setText:[ChannelWahl objectAtIndex:channel]];
    int befehlCount = befehlStepper.value;
    switch(befehlCount)
    {
        case 0: befehlCount = 0x10; //Noten
            break;
        case 1: befehlCount = 0x30; //Ctrl
            break;
        case 2: befehlCount = 0x40; // Prgr
            break;
        case 3: befehlCount = 0x7F;
            channel = 0; //Start/Stop
            break;
        case 4: befehlCount = 0; //Nur SysEx
            break;
    }
    Befehl[7] = (Byte)(channel + befehlCount);
    //label1.Text = "Ch+Cmd: " + switchCfg[7].ToString();
    [self send:(self)];
}

- (IBAction)befehlChange:(id)sender {
    [self channelChange:sender];
    [self wertChange:sender];
    [befehlLabel setText:[befehle objectAtIndex:befehlStepper.value]];
}

- (IBAction)wertChange:(id)sender {
    Befehl[8] = wertStepper.value;
    int x = befehlStepper.value;
    switch (x) {
        case 0:
            [wertLabel setText:[notenliste objectAtIndex:(wertStepper.value)]];
            break;
        case 1:
            [wertLabel setText:[ctrlListe objectAtIndex:(wertStepper.value)]];
            break;
        default:
            [wertLabel setText:[zahlenListe objectAtIndex:(wertStepper.value)]];
        break;
    }
    if (sender == wertStepper) [self send:sender];
}

- (IBAction)zeitChange:(id)sender {
    int zeit = zeitSlider.value * 10;
    if (zeitSlider.value > 127) {
        Befehl[10] = 0;
        zeit = 2500;
    }
    else Befehl[10] = zeitSlider.value;
    NSString *zeitString = [NSString stringWithFormat: @"%d", zeit];
    [zeitLabel setText:[zeitString stringByAppendingString:@" ms"]];
    [self send:sender];
}

@end

/*
- (id)init
{
    self = [super init];
    if (self) {
        midi = [[PGMidi alloc] init];
        midiStrings *myMidiListen = [[midiStrings alloc] init];
        notenliste = myMidiListen.NotenListe;
        zahlenListe = myMidiListen.zahlenListe;
        ctrlListe = myMidiListen.ctrlListe;
    }
    return self;
}

- (IBAction)sendBtnPressed:(id)sender {
    //const UInt8 prgrChange[] = { 0x90, 60, 60   };
    if ((sender == sendButton) || ([SofortBox state] == NSOnState)) [midi sendBytes:Befehl size:sizeof(Befehl)];
    //[midi sendBytes:Werk size:sizeof(Werk)];
    
}

- (IBAction)testBtnPressed:(id)sender {
    const UInt8 note[] = { 0x90, 0x48, 127   };
    [midi sendBytes:note size:sizeof(note)];
}

- (IBAction)IdChange:(id)sender {
    
    if ([IDWahl indexOfSelectedItem] == 0 ) Befehl[4] = 0x7F;
        else Befehl[4] = [IDWahl indexOfSelectedItem] -1;
            
            //if (Befehl[8] == 0x48) Befehl[8] = 0x36;
            //else Befehl[8] = 0x48;
            [self sendBtnPressed:sender];
    //if ([sofortSendenMenu state] == NSOnState) [self sendBtnPressed:(id)];
    
}

- (IBAction)inversCheck:(id)sender {
    int mode = 0;
    if (inverse.state == NSOnState) mode = mode + 1;
        if (toggle.state == NSOnState) mode = mode + 2;
            if (pulse.state == NSOnState) mode = mode + 4;
                if (swp.state == NSOnState) mode = mode + 8;
                    Befehl[9] = mode;
                    [self sendBtnPressed:sender];
}

- (IBAction)toggleCheck:(id)sender {
    if (pulse.state == NSOnState) [pulse setState:(NSOffState)];
    [self inversCheck:sender];
}

- (IBAction)pulseCheck:(id)sender {
    if (toggle.state == NSOnState) [toggle setState:(NSOffState)];
    [self inversCheck:sender];
}

- (IBAction)swpCheck:(id)sender {
    [self inversCheck:sender];
}

- (IBAction)ChannelChanged:(id)sender {
    int channel = (Byte)[ChannelWahl indexOfSelectedItem];
    int befehl = 0;
    int x = (Byte)[Befehle indexOfSelectedItem];
    switch(x)
    {
        case 0: befehl = 0x10; //Noten
            break;
        case 1: befehl = 0x30; //Ctrl
            break;
        case 2: befehl = 0x40; // Prgr
            break;
        case 3: befehl = 0x7F;
            channel = 0; //Start/Stop
            break;
        case 4: befehl = 0; //Nur SysEx
            break;
    }
    Befehl[7] = (Byte)(channel + befehl);
    //label1.Text = "Ch+Cmd: " + switchCfg[7].ToString();
    [self sendBtnPressed:(self)];
}

- (IBAction)noteChanged:(id)sender {
    Befehl[8] = [Noten indexOfSelectedItem];
    [self sendBtnPressed:sender];
}

- (IBAction)befehlChanged:(id)sender {
    [self ChannelChanged:sender];
    [Noten removeAllItems];
    switch ([Befehle indexOfSelectedItem]) {
        case 0:
            [Noten addItemsWithTitles:notenliste];
            break;
        case 1:
            [Noten addItemsWithTitles:ctrlListe];
            
        default:
            [Noten addItemsWithTitles:zahlenListe];
            break;
    }
}

- (IBAction)zeitChanged:(id)sender {
    int zeit = zeitSlider.intValue * 10;
    if (zeitSlider.intValue > 127) {
        Befehl[10] = 0;
        zeit = 2500;
    }
    else Befehl[10] = zeitSlider.intValue;
        NSString *zeitString = [NSString stringWithFormat: @"%d", zeit];
        [zeitLabel setStringValue:[zeitString stringByAppendingString:@" ms"]];
    [self sendBtnPressed:sender];
}

*/
